<?php

namespace Erlage\Photogram\Tools;

class CookieManager
{
    public static function unset(string $name): bool
    {
        return self::updateCookieState($name, '', '1');
    }

    public static function set(string $name, string $value): bool
    {
        return self::updateCookieState($name, $value, \strtotime('+30 days'));
    }

    public static function get(string $name): ?string
    {
        return $_COOKIE[$name] ?? null;
    }

    private static function updateCookieState(string $name, string $value, string $expires): bool
    {
        $options = array(
            'path'       => '/',
            'secure'     => true,
            'httponly'   => true,
            'samesite'   => 'Strict',
            'expires'    => $expires,
        );

        if (\version_compare(PHP_VERSION, '7.4.0', '<'))
        {
            self::pollyfill__setcookie($name, $value, $options);

            return true;
        }

        return \setcookie($name, $value, $options);
    }

    /**
     * Setcookie function with support for SameSite
     * @param  string|null  $samesite 'Lax' or 'Strict'
     */
    private static function pollyfill__setcookie($name, $value, array $options)
    {
        $header = 'Set-Cookie: ' . \rawurlencode($name) . '=' . \rawurlencode($value) . ';';
        $header .= $options['expires'] ? \sprintf('expires=%s', \gmdate('D, d M Y H:i:s \G\M\T', $options['expires'])) . '; ' : '';
        $header .= $options['path'] ? \sprintf('path=%s', \join('/', \array_map('rawurlencode', \explode('/', $options['path'])))) . '; ' : '';
        $header .= $options['secure'] ? 'secure; ' : '';
        $header .= $options['httponly'] ? 'httponly; ' : '';
        $header .= $options['samesite'] ? \sprintf('samesite=%s', \rawurlencode($options['samesite'])) . '; ' : '';

        return \header($header, false);
    }
}
